# Restaurant Menu Website

A modern restaurant menu website with admin panel for managing menu items.

## Features

- **Public Menu**: Clean, responsive design with category filtering
- **Admin Panel**: Add, edit, and delete menu items
- **Secure Login**: Admin access at `/admin` route
- **Local Storage**: Menu items persist in browser storage
- **Mobile Responsive**: Works on all device sizes

## Setup

1. Navigate to the project directory:
   ```bash
   cd "/Users/manny/Documents/MY PROJECTS/menu project"
   ```

2. Start the server:
   ```bash
   npm start
   ```

3. Open your browser and visit:
   - Main menu: http://localhost:3000
   - Admin panel: http://localhost:3000/admin

## Admin Credentials

- **Username**: admin
- **Password**: admin123

## File Structure

- `index.html` - Main menu page
- `admin.html` - Admin login and management page
- `styles.css` - All styling
- `script.js` - Main menu functionality
- `admin.js` - Admin panel functionality
- `server.js` - Simple Node.js server for routing

## Usage

### For Customers
- Visit the main page to view the menu
- Use category buttons to filter items
- Responsive design works on mobile and desktop

### For Admin
1. Go to `/admin` in the URL
2. Login with credentials above
3. Add new menu items with the form
4. Edit existing items by clicking "Edit"
5. Delete items by clicking "Delete"

## Customization

- Change admin credentials in `admin.js`
- Modify colors and styling in `styles.css`
- Add more categories by updating both HTML files
- Replace placeholder content with your restaurant's information
