<?php
session_start();
require_once 'config.php';

// Handle login
if ($_POST['action'] ?? '' === 'login') {
    if ($_POST['username'] === ADMIN_USERNAME && $_POST['password'] === ADMIN_PASSWORD) {
        $_SESSION['admin_logged_in'] = true;
        header('Content-Type: application/json');
        echo json_encode(['success' => true]);
        exit;
    } else {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'Invalid credentials']);
        exit;
    }
}

// Handle logout
if ($_GET['action'] ?? '' === 'logout') {
    session_destroy();
    header('Location: admin.php');
    exit;
}

// Check if logged in
$logged_in = $_SESSION['admin_logged_in'] ?? false;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Restaurant Menu</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="admin-container">
        <?php if (!$logged_in): ?>
        <div id="login-form" class="login-form">
            <h2>Admin Login</h2>
            <form onsubmit="login(event)">
                <input type="text" id="username" placeholder="Username" required>
                <input type="password" id="password" placeholder="Password" required>
                <button type="submit">Login</button>
            </form>
        </div>
        <?php else: ?>
        <div id="admin-panel" class="admin-panel">
            <header class="admin-header">
                <h1>Admin Dashboard</h1>
                <a href="?action=logout" class="logout-btn">Logout</a>
            </header>

            <nav class="admin-nav">
                <button class="nav-btn active" onclick="showPage('dashboard')">Dashboard</button>
                <button class="nav-btn" onclick="showPage('settings')">Settings</button>
                <button class="nav-btn" onclick="showPage('categories')">Categories</button>
                <button class="nav-btn" onclick="showPage('items')">Items</button>
            </nav>

            <div id="dashboard-page" class="admin-page">
                <h2>Welcome to Admin Dashboard</h2>
                <div class="dashboard-stats">
                    <div class="stat-card">
                        <h3>Total Items</h3>
                        <p id="total-items">0</p>
                    </div>
                    <div class="stat-card">
                        <h3>Food Items</h3>
                        <p id="food-items">0</p>
                    </div>
                    <div class="stat-card">
                        <h3>Drink Items</h3>
                        <p id="drink-items">0</p>
                    </div>
                </div>
            </div>

            <div id="settings-page" class="admin-page" style="display: none;">
                <h2>Settings</h2>
                <div class="settings-content">
                    <div class="branding-section">
                        <h3>Restaurant Name</h3>
                        <form onsubmit="updateRestaurantName(event)">
                            <input type="text" id="restaurant-name" placeholder="Enter Restaurant Name" required>
                            <button type="submit">Update Name</button>
                        </form>
                    </div>
                </div>
            </div>

            <div id="categories-page" class="admin-page" style="display: none;">
                <h2>Categories Management</h2>
                <div class="categories-content">
                    <div class="add-category">
                        <h3>Add New Category</h3>
                        <form onsubmit="addCategory(event)">
                            <input type="text" id="category-name" placeholder="Category Name" required>
                            <select id="category-type" required>
                                <option value="">Select Menu Type</option>
                                <option value="food">Food Menu</option>
                                <option value="drinks">Drinks Menu</option>
                            </select>
                            <button type="submit">Add Category</button>
                        </form>
                    </div>
                    
                    <div class="categories-list">
                        <h3>Current Categories</h3>
                        <div id="categories-display"></div>
                    </div>
                </div>
            </div>

            <div id="items-page" class="admin-page" style="display: none;">
                <h2>Items Management</h2>
                <div class="items-content">
                    <div class="add-item-form">
                        <h3>Add New Item</h3>
                        <form onsubmit="addItem(event)">
                            <input type="text" id="item-name" placeholder="Item Name" required>
                            <input type="text" id="item-description" placeholder="Description" required>
                            <input type="number" id="item-price" placeholder="Price" step="0.01" required>
                            <select id="item-category" required>
                                <option value="">Select Category</option>
                            </select>
                            <button type="submit">Add Item</button>
                        </form>
                    </div>

                    <div class="items-list">
                        <h3>Current Menu Items</h3>
                        <div id="admin-items"></div>
                    </div>
                </div>
                
                <!-- Edit Item Popup -->
                <div id="edit-popup" class="popup-overlay" style="display: none;">
                    <div class="popup-content">
                        <h3>Edit Item</h3>
                        <form onsubmit="updateItem(event)">
                            <input type="hidden" id="edit-item-id">
                            <input type="text" id="edit-item-name" placeholder="Item Name" required>
                            <input type="number" id="edit-item-price" placeholder="Price" step="0.01" required>
                            <select id="edit-item-category" required>
                                <option value="">Select Category</option>
                            </select>
                            <div class="popup-buttons">
                                <button type="submit">Update Item</button>
                                <button type="button" onclick="closeEditPopup()">Cancel</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <script src="admin-php.js"></script>
</body>
</html>
