<?php
session_start();
require_once 'config.php';

// Check if admin is logged in
if (!($_SESSION['admin_logged_in'] ?? false)) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

header('Content-Type: application/json');

$action = $_POST['action'] ?? $_GET['action'] ?? '';

try {
    switch ($action) {
        case 'get_stats':
            $stmt = $pdo->query("SELECT COUNT(*) as total FROM menu_items");
            $total = $stmt->fetchColumn();
            
            $stmt = $pdo->query("SELECT COUNT(*) as food FROM menu_items m JOIN categories c ON m.category_key = c.category_key WHERE c.type = 'food'");
            $food = $stmt->fetchColumn();
            
            $stmt = $pdo->query("SELECT COUNT(*) as drinks FROM menu_items m JOIN categories c ON m.category_key = c.category_key WHERE c.type = 'drinks'");
            $drinks = $stmt->fetchColumn();
            
            echo json_encode(['total' => $total, 'food' => $food, 'drinks' => $drinks]);
            break;

        case 'get_categories':
            $stmt = $pdo->query("SELECT * FROM categories ORDER BY type, sort_order");
            echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
            break;

        case 'add_category':
            $name = $_POST['name'];
            $type = $_POST['type'];
            $key = strtolower(str_replace(' ', '_', $name));
            
            $stmt = $pdo->prepare("SELECT MAX(sort_order) FROM categories WHERE type = ?");
            $stmt->execute([$type]);
            $max_order = $stmt->fetchColumn() ?: 0;
            
            $stmt = $pdo->prepare("INSERT INTO categories (name, type, category_key, sort_order) VALUES (?, ?, ?, ?)");
            $stmt->execute([$name, $type, $key, $max_order + 1]);
            
            echo json_encode(['success' => true, 'id' => $pdo->lastInsertId()]);
            break;

        case 'delete_category':
            $id = $_POST['id'];
            $stmt = $pdo->prepare("DELETE FROM categories WHERE id = ?");
            $stmt->execute([$id]);
            echo json_encode(['success' => true]);
            break;

        case 'move_category':
            $id = $_POST['id'];
            $direction = $_POST['direction'];
            
            $stmt = $pdo->prepare("SELECT * FROM categories WHERE id = ?");
            $stmt->execute([$id]);
            $category = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($direction === 'up') {
                $stmt = $pdo->prepare("SELECT * FROM categories WHERE type = ? AND sort_order < ? ORDER BY sort_order DESC LIMIT 1");
                $stmt->execute([$category['type'], $category['sort_order']]);
            } else {
                $stmt = $pdo->prepare("SELECT * FROM categories WHERE type = ? AND sort_order > ? ORDER BY sort_order ASC LIMIT 1");
                $stmt->execute([$category['type'], $category['sort_order']]);
            }
            
            $swap_category = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($swap_category) {
                $pdo->beginTransaction();
                
                $stmt = $pdo->prepare("UPDATE categories SET sort_order = ? WHERE id = ?");
                $stmt->execute([$swap_category['sort_order'], $category['id']]);
                
                $stmt = $pdo->prepare("UPDATE categories SET sort_order = ? WHERE id = ?");
                $stmt->execute([$category['sort_order'], $swap_category['id']]);
                
                $pdo->commit();
            }
            
            echo json_encode(['success' => true]);
            break;

        case 'get_items':
            $stmt = $pdo->query("SELECT * FROM menu_items ORDER BY name");
            echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
            break;

        case 'add_item':
            $stmt = $pdo->prepare("INSERT INTO menu_items (name, description, price, category_key) VALUES (?, ?, ?, ?)");
            $stmt->execute([$_POST['name'], $_POST['description'], $_POST['price'], $_POST['category']]);
            echo json_encode(['success' => true, 'id' => $pdo->lastInsertId()]);
            break;

        case 'update_item':
            $stmt = $pdo->prepare("UPDATE menu_items SET name = ?, price = ?, category_key = ? WHERE id = ?");
            $stmt->execute([$_POST['name'], $_POST['price'], $_POST['category'], $_POST['id']]);
            echo json_encode(['success' => true]);
            break;

        case 'delete_item':
            $stmt = $pdo->prepare("DELETE FROM menu_items WHERE id = ?");
            $stmt->execute([$_POST['id']]);
            echo json_encode(['success' => true]);
            break;

        case 'update_setting':
            $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");
            $stmt->execute([$_POST['key'], $_POST['value']]);
            echo json_encode(['success' => true]);
            break;

        case 'get_setting':
            $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
            $stmt->execute([$_GET['key']]);
            echo json_encode(['value' => $stmt->fetchColumn()]);
            break;

        default:
            echo json_encode(['error' => 'Invalid action']);
    }
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>
