<?php
require_once 'config.php';

// Get restaurant name
$stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'restaurant_name'");
$stmt->execute();
$restaurant_name = $stmt->fetchColumn() ?: 'The Restaurant';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us - <?php echo htmlspecialchars($restaurant_name); ?></title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header class="menu-header">
        <button class="header-back-btn" onclick="window.history.back()">←</button>
        <div class="header-logo-container" onclick="window.location.href='index.php'">
            <h1 class="header-logo-text"><?php echo htmlspecialchars($restaurant_name); ?></h1>
        </div>
        <button class="header-search-btn" style="visibility: hidden;">🔍</button>
    </header>

    <main>
        <section class="contact-section">
            <div class="container">
                <h2 class="section-title">Contact Us</h2>
                <div class="contact-content">
                    <div class="contact-info">
                        <h3>Get in Touch</h3>
                        <p><strong>Address:</strong> 123 Restaurant Street, City, State 12345</p>
                        <p><strong>Phone:</strong> (555) 123-4567</p>
                        <p><strong>Email:</strong> info@<?php echo strtolower(str_replace(' ', '', $restaurant_name)); ?>.com</p>
                        <p><strong>Hours:</strong> Mon-Sun 11:00 AM - 10:00 PM</p>
                    </div>
                </div>
            </div>
        </section>
    </main>
</body>
</html>
