-- Restaurant Menu Database Setup

CREATE DATABASE IF NOT EXISTS capacityfoodplug_menu;
USE capacityfoodplug_menu;

-- Categories table
CREATE TABLE categories (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    type ENUM('food', 'drinks') NOT NULL,
    category_key VARCHAR(50) NOT NULL,
    sort_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Menu items table
CREATE TABLE menu_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(200) NOT NULL,
    description TEXT,
    price DECIMAL(10,2) NOT NULL,
    category_key VARCHAR(50) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Settings table
CREATE TABLE settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    setting_key VARCHAR(100) NOT NULL UNIQUE,
    setting_value TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Clear existing data
DELETE FROM menu_items;
DELETE FROM categories;
DELETE FROM settings;

-- Insert default categories
INSERT INTO categories (name, type, category_key, sort_order) VALUES
('Appetizers', 'food', 'appetizers', 1),
('Main Course', 'food', 'mains', 2),
('Desserts', 'food', 'desserts', 3),
('Hot Drinks', 'drinks', 'hot', 1),
('Cold Drinks', 'drinks', 'cold', 2),
('Fresh Juices', 'drinks', 'juice', 3);

-- Insert sample menu items
INSERT INTO menu_items (name, description, price, category_key) VALUES
('Caesar Salad', 'Crisp romaine lettuce with parmesan cheese, croutons and our signature Caesar dressing', 1500.00, 'appetizers'),
('Chicken Wings', 'Spicy buffalo wings served with ranch dipping sauce', 2000.00, 'appetizers'),
('Grilled Chicken', 'Fresh grilled chicken breast marinated with herbs and spices, served with vegetables', 3500.00, 'mains'),
('Beef Steak', 'Tender beef steak grilled to perfection with garlic butter', 4500.00, 'mains'),
('Jollof Rice', 'Traditional Nigerian jollof rice with chicken and plantain', 2500.00, 'mains'),
('Chocolate Cake', 'Rich chocolate cake layered with vanilla cream and topped with chocolate ganache', 1200.00, 'desserts'),
('Ice Cream', 'Creamy vanilla ice cream with chocolate chips', 800.00, 'desserts'),
('Coffee', 'Premium roasted coffee beans brewed to perfection', 500.00, 'hot'),
('Hot Tea', 'Aromatic tea blend served hot with honey', 400.00, 'hot'),
('Iced Tea', 'Refreshing iced tea with lemon and mint', 600.00, 'cold'),
('Coca Cola', 'Chilled Coca Cola served with ice', 300.00, 'cold'),
('Orange Juice', 'Freshly squeezed orange juice packed with vitamin C', 700.00, 'juice'),
('Apple Juice', 'Fresh apple juice with natural sweetness', 650.00, 'juice');

-- Insert default settings
INSERT INTO settings (setting_key, setting_value) VALUES
('restaurant_name', 'Capacity Food Plug'),
('background_image', '');
