// Drinks menu JavaScript

// Toggle search
function toggleSearch() {
    const searchContainer = document.getElementById('search-container');
    const searchInput = document.getElementById('search-input');
    
    if (searchContainer.style.display === 'none') {
        searchContainer.style.display = 'block';
        searchInput.focus();
    } else {
        searchContainer.style.display = 'none';
        searchInput.value = '';
        showAllSections();
    }
}

// Search items
function searchItems() {
    const searchTerm = document.getElementById('search-input').value.toLowerCase();
    
    if (searchTerm === '') {
        showAllSections();
        return;
    }
    
    const filteredItems = menuItems.filter(item => 
        item.name.toLowerCase().includes(searchTerm) ||
        item.description.toLowerCase().includes(searchTerm)
    );
    
    // Show search results in first category section
    const firstCategory = categories[0];
    if (firstCategory) {
        const container = document.getElementById(`${firstCategory.category_key}-items`);
        container.innerHTML = filteredItems.map(item => `
            <div class="menu-item">
                <h3>${item.name}</h3>
                <div class="price">₦${parseFloat(item.price).toFixed(2)}</div>
            </div>
        `).join('');
        
        // Hide other sections during search
        categories.slice(1).forEach(category => {
            const section = document.getElementById(`section-${category.category_key}`);
            if (section) section.style.display = 'none';
        });
        document.getElementById(`section-${firstCategory.category_key}`).style.display = 'block';
    }
}

// Show all sections
function showAllSections() {
    categories.forEach(category => {
        const section = document.getElementById(`section-${category.category_key}`);
        const container = document.getElementById(`${category.category_key}-items`);
        
        if (section && container) {
            const categoryItems = menuItems.filter(item => item.category_key === category.category_key);
            
            if (categoryItems.length > 0) {
                container.innerHTML = categoryItems.map(item => `
                    <div class="menu-item">
                        <h3>${item.name}</h3>
                        <div class="price">₦${parseFloat(item.price).toFixed(2)}</div>
                    </div>
                `).join('');
                section.style.display = 'block';
            } else {
                section.style.display = 'none';
            }
        }
    });
}

// Scroll to category section
function scrollToCategory(categoryKey) {
    const section = document.getElementById(`section-${categoryKey}`);
    const offset = 140; // Header + categories height
    
    window.scrollTo({
        top: section.offsetTop - offset,
        behavior: 'smooth'
    });
    
    // Update active button
    document.querySelectorAll('.category-btn').forEach(btn => {
        btn.classList.remove('active');
    });
    const activeBtn = document.querySelector(`[data-category="${categoryKey}"]`);
    if (activeBtn) activeBtn.classList.add('active');
}

// Auto-update active category on scroll
function updateActiveCategory() {
    const sections = categories.map(cat => cat.category_key);
    const scrollPos = window.scrollY + 200;
    
    for (let i = sections.length - 1; i >= 0; i--) {
        const section = document.getElementById(`section-${sections[i]}`);
        if (section && section.offsetTop <= scrollPos) {
            document.querySelectorAll('.category-btn').forEach(btn => {
                btn.classList.remove('active');
            });
            const activeBtn = document.querySelector(`[data-category="${sections[i]}"]`);
            if (activeBtn) activeBtn.classList.add('active');
            break;
        }
    }
}

// Initialize
document.addEventListener('DOMContentLoaded', function() {
    showAllSections();
    window.addEventListener('scroll', updateActiveCategory);
});
