<?php
require_once 'config.php';

// Get restaurant name
$stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'restaurant_name'");
$stmt->execute();
$restaurant_name = $stmt->fetchColumn() ?: 'The Restaurant';

// Get food categories
$stmt = $pdo->prepare("SELECT * FROM categories WHERE type = 'food' ORDER BY sort_order");
$stmt->execute();
$categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get food items
$stmt = $pdo->prepare("SELECT * FROM menu_items WHERE category_key IN (SELECT category_key FROM categories WHERE type = 'food') ORDER BY name");
$stmt->execute();
$menu_items = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Food Menu - <?php echo htmlspecialchars($restaurant_name); ?></title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header class="menu-header">
        <button class="header-back-btn" onclick="window.history.back()">←</button>
        <div class="header-logo-container" onclick="window.location.href='index.php'">
            <h1 class="header-logo-text"><?php echo htmlspecialchars($restaurant_name); ?></h1>
        </div>
        <button class="header-search-btn" onclick="toggleSearch()">🔍</button>
    </header>

    <div class="search-container" id="search-container" style="display: none;">
        <input type="text" id="search-input" placeholder="Search food items..." oninput="searchItems()">
    </div>

    <div class="menu-categories">
        <div class="categories-marquee" id="categories-container">
            <?php foreach($categories as $index => $category): ?>
                <button class="category-btn <?php echo $index === 0 ? 'active' : ''; ?>" 
                        data-category="<?php echo $category['category_key']; ?>" 
                        onclick="scrollToCategory('<?php echo $category['category_key']; ?>')">
                    <?php echo htmlspecialchars($category['name']); ?>
                </button>
            <?php endforeach; ?>
        </div>
    </div>

    <main>
        <section class="menu-section">
            <div class="container" id="menu-container">
                <?php foreach($categories as $category): ?>
                    <div id="section-<?php echo $category['category_key']; ?>" class="category-section">
                        <h2 class="section-title"><?php echo htmlspecialchars($category['name']); ?></h2>
                        <div id="<?php echo $category['category_key']; ?>-items" class="menu-grid">
                            <?php foreach($menu_items as $item): ?>
                                <?php if($item['category_key'] === $category['category_key']): ?>
                                    <div class="menu-item" onclick="showItemDetails(<?php echo json_encode($item['name']); ?>, <?php echo json_encode(number_format($item['price'], 2)); ?>, <?php echo json_encode($item['description'] ?? 'Delicious item from our menu'); ?>)">
                                        <h3><?php echo htmlspecialchars($item['name']); ?></h3>
                                        <div class="price">₦<?php echo number_format($item['price'], 2); ?></div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </section>
    </main>

    <!-- Item Detail Popup -->
    <div id="itemPopup" class="item-popup">
        <div class="item-popup-header">
            <h3 id="popupItemName"></h3>
            <button class="close-btn" onclick="hideItemDetails()">&times;</button>
        </div>
        <div class="price" id="popupItemPrice"></div>
        <div class="description" id="popupItemDescription"></div>
    </div>

    <script>
        const menuItems = <?php echo json_encode($menu_items); ?>;
        const categories = <?php echo json_encode($categories); ?>;
        
        function showItemDetails(name, price, description) {
            document.getElementById('popupItemName').textContent = name;
            document.getElementById('popupItemPrice').textContent = '₦' + price;
            document.getElementById('popupItemDescription').textContent = description;
            document.getElementById('itemPopup').classList.add('active');
        }
        
        function hideItemDetails() {
            document.getElementById('itemPopup').classList.remove('active');
        }
    </script>
    <script src="food-menu.js"></script>
</body>
</html>
