<?php
require_once 'config.php';

// Get restaurant name
$stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'restaurant_name'");
$stmt->execute();
$restaurant_name = $stmt->fetchColumn() ?: 'The Restaurant';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($restaurant_name); ?></title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="landing-page">
        <header class="landing-header">
            <div class="logo-container">
                <h1 id="landing-name"><?php echo htmlspecialchars($restaurant_name); ?></h1>
            </div>
            <p>Welcome to our dining experience</p>
        </header>

        <main class="landing-main">
            <div class="menu-options">
                <div class="menu-option" onclick="window.location.href='food-menu.php'">
                    <div class="icon">🍽️</div>
                    <h2>Food Menu</h2>
                </div>
                
                <div class="menu-option" onclick="window.location.href='drinks-menu.php'">
                    <div class="icon">🍷</div>
                    <h2>Drinks Menu</h2>
                </div>
                
                <div class="menu-option" onclick="window.location.href='contact.php'">
                    <div class="icon">📞</div>
                    <h2>Contact Us</h2>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
